package ru.yandex.autotests.innerpochta.wmi.core.consts;

public enum Scopes {
    PRODUCTION("pg"),
    INTRANET_PRODUCTION("webcorp"),
    TESTING("test");

    private String name;

    Scopes(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static Scopes from(String value) {
        for (Scopes scope : values()) {
            if (scope.name.equals(value)) {
                return scope;
            }
        }
        throw new EnumConstantNotPresentException(Scopes.class, value);
    }
}
