package ru.yandex.autotests.innerpochta.wmi.core.consts;

import gumi.builders.UrlBuilder;
import org.apache.commons.codec.binary.Base64;
import ru.yandex.autotests.innerpochta.beans.folderlist.Symbol;
import ru.yandex.autotests.innerpochta.wmi.core.oper.ComposeCheck;
import ru.yandex.autotests.innerpochta.wmi.core.oper.FolderList;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.UnknownHostException;

import static com.google.common.base.Charsets.UTF_8;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 26.05.15
 * Time: 14:38
 */
public class ShinglerPattern {

    public enum Sources {
        WMI("wmi"),
        MOBILE("mobile"),
        TEST("test");

        private String source;

        private Sources(String source) {
            this.source = source;
        }

        public String getSource() {
            return source;
        }
    }

    public enum OperIds {
        SPAM("foo"),
        NOT_SPAM("antifoo"),
        DELETE("delete"),
        UNSUBSCRIBE("unsubscribe"),
        MOVE("move");

        private String id;

        private OperIds(String id) {
            this.id = id;
        }

        public String id() {
            return id;
        }
    }

    //тайм содержит 10 цифр
    public static final String YES = "yes";
    public static final String NO = "no";

    public static final String CLIENT_PATTERN = "[^A-Za-z0-9]";
    public static final String TIME_PATTERN = "[0-9]{10}";

    private String destFid;
    private ComposeCheck composeCheck;
    private String stid;
    private String type;
    private String mid;
    private String move;
    //по умолчанию входящие
    private String folder;
    private String seen;
    private String source = Sources.WMI.getSource();

   public static ShinglerPattern emptyPattern() {
       return new ShinglerPattern();
   }

    public ShinglerPattern setDestFid(String destFit) {
        this.destFid = destFit;
        return this;
    }

    public ShinglerPattern setComposeCheck(ComposeCheck composeCheck) {
        this.composeCheck = composeCheck;
        return this;
    }

    public ShinglerPattern setStid(String stid) {
        this.stid = stid;
        return this;
    }

    public ShinglerPattern setType(String type) {
        this.type = type;
        return this;
    }

    public ShinglerPattern setFolder(String folder) {
        this.folder = folder;
        return this;
    }

    public ShinglerPattern setSeen(String seen) {
        this.seen = seen;
        return this;
    }

    public ShinglerPattern setSource(String source) {
        this.source = source;
        return this;
    }


    public ShinglerPattern setMid(String mid) {
        this.mid = mid;
        return this;
    }

    public String get()
            throws UnsupportedEncodingException, UnknownHostException {

        String url;
        if (destFid != null)
        {
            url = URLDecoder.decode("/check" + UrlBuilder.empty()
                    .addParameter("login", composeCheck.getLogin())
                    .addParameter("suid", composeCheck.getSuid())
                    .addParameter("uid", composeCheck.getUid())
                    .addParameter("karma", "0")
                    .addParameter("karma_status", "0")
                    .addParameter("ip", InetAddress.getLocalHost().getHostAddress())
                    .addParameter("mid", mid)
                    .addParameter("data", TIME_PATTERN)
                    .addParameter("stid", stid)
                    .addParameter("type", type)
                    .addParameter("folder", folder)
                    .addParameter("dest_folder", destFid)
                    .addParameter("seen", seen)
                    .toString(), "UTF-8");
        } else {
            url = URLDecoder.decode("/check" + UrlBuilder.empty()
                    .addParameter("login", composeCheck.getLogin())
                    .addParameter("suid", composeCheck.getSuid())
                    .addParameter("uid", composeCheck.getUid())
                    .addParameter("karma", "0")
                    .addParameter("karma_status", "0")
                    .addParameter("ip", InetAddress.getLocalHost().getHostAddress())
                    .addParameter("mid", mid)
                    .addParameter("data", TIME_PATTERN)
                    .addParameter("stid", stid)
                    .addParameter("type", type)
                    .addParameter("folder", folder)
                    .addParameter("seen", seen)
                    .toString(), "UTF-8");
        }

        return url.replaceAll("\\.", "\\\\.").replaceAll("\\?", "\\\\?") + "&client=.*&source=" + source;
    }

    public static String encodedFolder(Symbol symbol, FolderList folderList) {
        return Base64.encodeBase64URLSafeString(folderList.nameBySymbol(symbol).getBytes(UTF_8));
    }
}