package ru.yandex.autotests.innerpochta.wmi.core.filter;

import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import ru.yandex.autotests.innerpochta.wmi.core.base.Context;

import java.io.IOException;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 01.01.13
 * Time: 19:22
 */
public class AddHeaderFilter implements Filter {

    private Header[] headers;

    public AddHeaderFilter(Header... headers) {
        this.headers = headers;
    }

    @Override
    public Request filter(Request request, Context ctx) {
        for (Header header : headers) {
            request.addHeader(header);
        }

        return ctx.next(request);
    }

    @Override
    public HttpResponse filter(HttpResponse response, Context ctx) throws IOException {
        return ctx.next(response);
    }
}
