package ru.yandex.autotests.innerpochta.wmi.core.filter;

import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import ru.yandex.autotests.innerpochta.wmi.core.base.Context;

import java.io.IOException;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 27.12.12
 * Time: 18:16
 * Реализация интерфейса занимается действиями с респонсом и реквестом.
 * Можно менять и то и другое перед и после выполнения, можно логировать разными способами
 */
public interface Filter {

    /**
     * @param request
     * @param ctx
     * @return не забыть вернуть ctx.next(request); - чтобы не прерывалась цепочка фильтров
     */
    public Request filter(Request request, Context ctx);


    /**
     * @param response
     * @param ctx
     * @return Не забыть вернуть ctx.next(response); - чтобы не прерывалась цепочка фильтров
     * @throws IOException
     */
    public HttpResponse filter(HttpResponse response, Context ctx) throws IOException;
}
