package ru.yandex.autotests.innerpochta.wmi.core.filter;

import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.XML;
import ru.yandex.autotests.innerpochta.wmi.core.base.Context;

import java.io.IOException;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 02.01.13
 * Time: 16:27
 */
public class JsonToXML implements Filter {
    @Override
    public Request filter(Request request, Context ctx) {
        return ctx.next(request);
    }

    @Override
    public HttpResponse filter(HttpResponse response, Context ctx) throws IOException {
        String resp = EntityUtils.toString(response.getEntity(), "UTF-8");
        try {
            resp = "<root>" + XML.toString(new JSONArray(resp)) + "</root>";
        } catch (JSONException e) {
            throw new RuntimeException(e);
        }
        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setContent(IOUtils.toInputStream(resp, "UTF-8"));
        entity.setContentType(new BasicHeader("Content-Type", "text/plain; charset = UTF-8"));
        response.setEntity(new BufferedHttpEntity(entity));

        return ctx.next(response);
    }
}
