package ru.yandex.autotests.innerpochta.wmi.core.filter;

import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import ru.yandex.autotests.innerpochta.wmi.core.base.Context;
import ru.yandex.autotests.innerpochta.wmi.core.base.RequestExecutor;

import java.io.IOException;

import static org.apache.commons.lang.StringUtils.defaultIfEmpty;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 02.01.13
 * Time: 18:51
 */
public class OperChangeFilter implements Filter {

    private String prefix = "";
    private String method = "";
    private String description;

    /**
     * Only with builder
     */
    private OperChangeFilter() {

    }

    public void prefix(String prefix) {
        this.prefix = prefix;
    }

    public void method(String method) {
        this.method = method;
    }

    public void description(String description) {
        this.description = description;
    }

    @Override
    public Request filter(Request request, Context ctx) {
        ctx.descr(defaultIfEmpty(description, ctx.descr()));
        ctx.cmd(defaultIfEmpty(prefix + method, ctx.cmd()));
        Request modified = RequestExecutor.createRequest(ctx);
        return ctx.next(modified);
    }

    @Override
    public HttpResponse filter(HttpResponse response, Context ctx) throws IOException {
        return ctx.next(response);
    }

    public static class OperChangeFilterBuilder {

        private OperChangeFilterBuilder() {
            filter = new OperChangeFilter();
        }

        private OperChangeFilter filter;

        public OperChangeFilterBuilder prefix(String prefix) {
            filter.prefix(prefix);
            return this;
        }

        public OperChangeFilterBuilder method(String method) {
            filter.method(method);
            return this;
        }

        public OperChangeFilterBuilder description(String description) {
            filter.description(description);
            return this;
        }

        public OperChangeFilter build() {
            return filter;
        }

        public static OperChangeFilterBuilder changeOper() {
            return new OperChangeFilterBuilder();
        }
    }
}
