package ru.yandex.autotests.innerpochta.wmi.core.filter;

import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import ru.yandex.autotests.innerpochta.wmi.core.base.Context;

import java.io.IOException;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 02.01.13
 * Time: 16:27
 * Фильтр для игнорирования различий между динамическими частями урлов у vdirect-ссылок
 * Заменяет все одной строкой
 * Необходим для b2b тестов
 */
public class VDirectCut implements Filter {
    @Override
    public Request filter(Request request, Context ctx) {
        return ctx.next(request);
    }

    @Override
    public HttpResponse filter(HttpResponse response, Context ctx) throws IOException {
        String resp = EntityUtils.toString(response.getEntity(), "UTF-8");

        String regexp1 = "hash=\"[\\w\\d]+\"";
        String replacement1 = "replaced_for_TEST_SOME_HASH";
        resp = resp.replaceAll(regexp1, "hash=\"" + replacement1 + "\"");

        String regexp = "[\\w-]+,\\d+";
        String replacement = "replaced_for_TEST_purposes";
        resp = resp
                .replaceAll("url/" + regexp + "/", "url/" + replacement + "/")
                .replaceAll("urls/" + regexp + "/", "urls/" + replacement + "/")
                .replaceAll("ftp/" + regexp + "/", "ftp/" + replacement + "/");


        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setContent(IOUtils.toInputStream(resp, "UTF-8"));
        entity.setContentType(new BasicHeader("Content-Type", "text/plain; charset = UTF-8"));
        response.setEntity(new BufferedHttpEntity(entity));

        return ctx.next(response);
    }
}
