package ru.yandex.autotests.innerpochta.wmi.core.hound;

import com.jayway.restassured.builder.ResponseSpecBuilder;
import com.jayway.restassured.specification.ResponseSpecification;
import org.apache.commons.httpclient.HttpStatus;
import org.hamcrest.Matcher;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.nullValue;

public class HoundResponses {
    public static ResponseSpecification ok200() {
        return new ResponseSpecBuilder()
                .expectStatusCode(HttpStatus.SC_OK)
                .expectBody(".", not(empty()))
                .expectBody("error", is(nullValue()))
                .expectContentType("application/json")
                .build();
    }

    public static ResponseSpecification unknownUid() {
        return new ResponseSpecBuilder()
                .expectStatusCode(org.eclipse.jetty.http.HttpStatus.BAD_REQUEST_400)
                .expectBody("error.message", equalTo("uid not found"))
                .expectBody("error.code", equalTo(7001))
                .build();
    }

    public static ResponseSpecification invalidArgument(Matcher<?> reasonMatcher) {
        return new ResponseSpecBuilder()
                .expectStatusCode(org.eclipse.jetty.http.HttpStatus.BAD_REQUEST_400)
                .expectBody("error.message", equalTo("invalid argument"))
                .expectBody("error.reason", reasonMatcher)
                .build();
    }

    public static ResponseSpecification invalidArgumentWithCode(Matcher<?> codeMatcher) {
        return new ResponseSpecBuilder()
                .expectStatusCode(org.eclipse.jetty.http.HttpStatus.BAD_REQUEST_400)
                .expectBody("error.message", equalTo("invalid argument"))
                .expectBody("error.code", codeMatcher)
                .build();
    }

    public static ResponseSpecification noSuchTab() {
        return new ResponseSpecBuilder()
                .expectStatusCode(org.eclipse.jetty.http.HttpStatus.BAD_REQUEST_400)
                .expectBody("error.message", equalTo("no such tab"))
                .expectBody("error.code", equalTo(5021))
                .build();
    }
}
