package ru.yandex.autotests.innerpochta.wmi.core.matchers;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;

import java.awt.image.BufferedImage;

public class BufferedImageMatcher extends TypeSafeMatcher<BufferedImage> {
    private BufferedImage expected;

    public BufferedImageMatcher(BufferedImage expected) {
        this.expected = expected;
    }

    @Override
    protected boolean matchesSafely(BufferedImage item) {
        return item != null
                && expected != null
                && item.getType() == expected.getType()
                && item.getWidth() == expected.getWidth()
                && item.getHeight() == expected.getHeight();
    }

    @Override
    public void describeTo(Description description) {
        fillDescription(expected, description);
    }

    @Override
    protected void describeMismatchSafely(BufferedImage item, Description mismatchDescription) {
        fillDescription(item, mismatchDescription);
    }

    @Factory
    public static BufferedImageMatcher hasSameTypeAndSize(BufferedImage expected) {
        return new BufferedImageMatcher(expected);
    }

    private static void fillDescription(BufferedImage image, Description description) {
        if (image == null) {
            description.appendText("null");
        } else {
            description
                .appendText("изображение типа ")
                .appendValue(image.getType())
                .appendText(" размером ")
                .appendValue(image.getWidth())
                .appendText(" на ")
                .appendValue(image.getHeight());
        }
    }
}
