package ru.yandex.autotests.innerpochta.wmi.core.matchers;

import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.DefaultHttpClient;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;

import java.util.List;

import static ch.lambdaj.Lambda.*;
import static org.hamcrest.Matchers.equalTo;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 7/12/13
 * Time: 1:32 AM
 */
public class CookieMatcher extends TypeSafeMatcher<CookieStore> {

    private String cookieName;

    public CookieMatcher(String cookieName) {
        this.cookieName = cookieName;
    }

    @Factory
    public static CookieMatcher сookieExist(String cookieName) {
        return new CookieMatcher(cookieName);
    }

    private Cookie findCookie(String name, CookieStore cookieStore) {
        return selectFirst(cookieStore.getCookies(),
                having(on(Cookie.class).getName(), equalTo(name)));
    }

    @Override
    protected boolean matchesSafely(CookieStore cookieStore) {
        return findCookie(cookieName, cookieStore) != null;
    }

    public void describeMismatchSafely(CookieStore cookieStore, Description mismatchDescription) {
        List<Cookie> cookieList = cookieStore.getCookies();
        mismatchDescription.appendText(String.format("Cookie не найдена %s  ", cookieName));
        mismatchDescription.appendValueList("\nНайдены cookie: \n----->", "\n----->", "", cookieList);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText(String.format("существует cookie с именем %s", cookieName));
    }
}
