package ru.yandex.autotests.innerpochta.wmi.core.matchers;

import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

import java.util.Date;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 12.03.13
 * Time: 17:55
 */
public class DateMatcher extends TypeSafeMatcher<Date> {

    private CompareCode compareCode;
    private Date expected;

    public DateMatcher(CompareCode compareCode, Date expected) {
        this.compareCode = compareCode;
        this.expected = expected;
    }

    @Override
    protected boolean matchesSafely(Date actual) {
        return actual.compareTo(expected) == compareCode.code();
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("Полученная дата ").appendText(compareCode.description()).appendText(" - ")
                .appendValue(expected);
    }

    @Override
    protected void describeMismatchSafely(Date actual, Description mismatchDescription) {
        mismatchDescription.appendText("Получено: ").appendValue(actual);
    }

    public static DateMatcher before(Date dateExpected) {
        return new DateMatcher(CompareCode.BEFORE, dateExpected);
    }

    public static DateMatcher after(Date dateExpected) {
        return new DateMatcher(CompareCode.AFTER, dateExpected);
    }

    public static DateMatcher equal(Date dateExpected) {
        return new DateMatcher(CompareCode.EQUAL, dateExpected);
    }

    public enum CompareCode {
        BEFORE(-1, "раньше чем"),
        EQUAL(0, "эквивалентна"),
        AFTER(1, "после");

        private int compareCode;
        private String description;


        private CompareCode(int compareCode, String description) {
            this.compareCode = compareCode;
            this.description = description;
        }

        public int code() {
            return compareCode;
        }

        public String description() {
            return description;
        }
    }
}
