package ru.yandex.autotests.innerpochta.wmi.core.matchers;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 11.03.15
 * Time: 17:46
 */

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class IsArrayContaining<T> extends TypeSafeMatcher<T[]> {
    private final Matcher<? super T> elementMatcher;

    public IsArrayContaining(Matcher<? super T> elementMatcher) {
        this.elementMatcher = elementMatcher;
    }

    @Override
    public boolean matchesSafely(T[] array) {
        int i = 0;
        for (T item : array) {
            if (elementMatcher.matches(item)) {
                 i ++;
            }
        }
        return i == 1;
    }

    @Override
    public void describeTo(Description description) {
        description
                .appendText("an array containing ")
                .appendDescriptionOf(elementMatcher);
    }
}
