package ru.yandex.autotests.innerpochta.wmi.core.matchers;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 31.08.12
 * Time: 14:09
 */
public class IsNot<T> extends TypeSafeMatcher<T> {
    private final Matcher<T> matcher;

    public IsNot(Matcher<T> matcher) {
        this.matcher = matcher;
    }

    @Override
    protected boolean matchesSafely(Object arg) {
        return !matcher.matches(arg);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("not ").appendDescriptionOf(matcher);
    }

    @Override
    protected void describeMismatchSafely(Object obj, Description mismatchDescription) {
        matcher.describeMismatch(obj, mismatchDescription);
    }


    /**
     * Creates a matcher that wraps an existing matcher, but inverts the logic by which
     * it will match.
     * <p/>
     * For example:
     * <pre>assertThat(cheese, is(not(equalTo(smelly))))</pre>
     *
     * @param matcher the matcher whose sense should be inverted
     */
    @Factory
    public static <T> Matcher<T> not(Matcher<T> matcher) {
        return new IsNot<T>(matcher);
    }
}
