package ru.yandex.autotests.innerpochta.wmi.core.matchers;

import com.google.common.collect.Lists;
import org.hamcrest.Factory;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;

import java.util.Collection;

import static org.hamcrest.core.IsEqual.equalTo;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 7/2/13
 * Time: 11:54 PM
 */
public class IsSizeEqualMatcher {
    public static <T> Matcher<Collection<T>> hasSameSizeAs(Collection<T> list) {
        return new FeatureMatcher<Collection<T>, Integer>(equalTo(list.size()),
                "expected size ", "got size ") {
            @Override
            protected Integer featureValueOf(Collection<T> actual) {
                return actual.size();
            }
        };
    }

    @Factory
    public static <T> Matcher<? super Iterable<? super String>> hasSizeAs(Integer size) {
        return new FeatureMatcher<Iterable<? super String>, Integer>(equalTo(size),
                "expected size ", "got size ") {

            @Override
            protected Integer featureValueOf(Iterable<? super String> actual) {
                return Lists.newArrayList(actual).size();
            }
        };
    }
}

