package ru.yandex.autotests.innerpochta.wmi.core.matchers;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;
import java.util.regex.Pattern;
import java.util.regex.Matcher;

public class RegexMatcher extends TypeSafeMatcher<String> {
    private String stringPattern ;
    public RegexMatcher(String expected) {
        stringPattern = expected;
    }

    @Override
    public boolean matchesSafely(String inString) {
        Pattern pattern = Pattern.compile(stringPattern);
        Matcher  matcher = pattern.matcher(inString);
        return matcher.find();
    }

    @Override
    protected void describeMismatchSafely(String item, Description mismatchDescription) {
        mismatchDescription.appendText("Incoming string does not contain this pattern: ").appendValue(stringPattern);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("Incoming string must contain this pattern ").appendValue(stringPattern);
    }

    @Factory
    public static RegexMatcher isContain(String expected) {
        return new RegexMatcher(expected);
    }
}

