package ru.yandex.autotests.innerpochta.wmi.core.matchers;

import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.LogManager;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.wmi.core.obj.SettingsRpopperCreateObj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.SettingsRpopperList;

import java.io.IOException;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 06.01.13
 * Time: 22:49
 */
public class RpopperCreatedMatcher extends TypeSafeMatcher<DefaultHttpClient> {

    private String pID;
    private SettingsRpopperCreateObj rpopper;


    public RpopperCreatedMatcher(String pID, SettingsRpopperCreateObj rpopper) {
        this.pID = pID;
        this.rpopper = rpopper;
    }

    @Override
    protected boolean matchesSafely(DefaultHttpClient hc) {
        LogManager.getLogger(this.getClass()).info("Ищем сборщик с ID - " + pID);
        try {
            return api(SettingsRpopperList.class).post().via(hc).isRpopperCreated(pID, rpopper);
        } catch (Exception e) {
            throw new RuntimeException("Не смогли получить состояние сборщика", e);
        }
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("Ожидалось наличие сборщика ")
                .appendValue(pID).appendText(" - ").appendValue(rpopper.getEmail());
    }

    @Override
    protected void describeMismatchSafely(DefaultHttpClient item, Description mismatchDescription) {
        mismatchDescription.appendText("Сборщик не найден");
    }

    @Factory
    public static RpopperCreatedMatcher hasCreatedRpopper(String pID, SettingsRpopperCreateObj rpopper) {
        return new RpopperCreatedMatcher(pID, rpopper);
    }
}
