package ru.yandex.autotests.innerpochta.wmi.core.matchers;

import org.apache.http.impl.client.DefaultHttpClient;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;
import ru.yandex.autotests.innerpochta.wmi.core.oper.SettingsSetup;

import static org.hamcrest.Matchers.is;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 06.01.13
 * Time: 21:24
 */
public class SettingsValueMatcher extends TypeSafeMatcher<DefaultHttpClient> {

    private Oper<?> oper = jsx(SettingsSetup.class);
    private String optionName;
    private Matcher<String> expectedMatcher;
    private String actualValue;

    public SettingsValueMatcher(String optionName, Matcher<String> expectedValue) {
        this.optionName = optionName;
        this.expectedMatcher = expectedValue;
    }

    public SettingsValueMatcher with(Oper<?> oper) {
        this.oper = oper;
        return this;
    }

    @Override
    protected boolean matchesSafely(DefaultHttpClient hc) {
        SettingsSetup resp = (SettingsSetup) oper.get().via(hc).as(SettingsSetup.class);
        actualValue = resp.getSettingValue(optionName);
        return expectedMatcher.matches(actualValue);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("Ожидалось значение ").appendValue(optionName).appendText(" ")
                .appendDescriptionOf(expectedMatcher);
    }

    @Override
    protected void describeMismatchSafely(DefaultHttpClient item, Description mismatchDescription) {
        expectedMatcher.describeMismatch(actualValue, mismatchDescription);

    }


    @Factory
    public static SettingsValueMatcher hasSetting(String name, String value) {
        return hasSetting(name, is((value.equals("off") ? "" : value)));
    }

    @Factory
    public static SettingsValueMatcher hasSetting(String optionName, Matcher<String> expectedValue) {
        return new SettingsValueMatcher(optionName, expectedValue);
    }

}
