package ru.yandex.autotests.innerpochta.wmi.core.matchers;

import org.eclipse.jetty.http.HttpStatus;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 30.12.12
 * Time: 23:25
 */
public class StatusCodeMatcher<T extends Oper<T>> extends TypeSafeMatcher<T> {

    private int statusCode;

    public StatusCodeMatcher(int statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    protected boolean matchesSafely(T item) {
        return null != item.statusLine() && item.statusLine().getStatusCode() == statusCode;
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("Ожидался статус код ")
                .appendValue(HttpStatus.getCode(statusCode).toString());
    }

    @Override
    protected void describeMismatchSafely(T item, Description mismatchDescription) {
        mismatchDescription.appendText("Команда ").appendValue(item.getClass().getSimpleName())
                .appendText(" вернула ")
                .appendValue(null == item.statusLine() ? "<НЕ БЫЛА ВЫПОЛНЕНА>" : item.statusLine().toString());
    }

    @Factory
    public static StatusCodeMatcher hasStatusCode(int statusCode) {
        return new StatusCodeMatcher(statusCode);
    }
}