package ru.yandex.autotests.innerpochta.wmi.core.matchers;

import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.util.DifferWithPrettidiff;

import java.util.ArrayList;
import java.util.List;

import static ru.yandex.autotests.plugins.testpers.html.common.HtmlUtils.*;
import static ru.yandex.qatools.elliptics.ElClient.elliptics;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 19.05.13
 * Time: 12:37
 */
public class StringDiffer extends TypeSafeMatcher<String> {
    private String expected;
    private List<String> excludePatterns = new ArrayList<>();

    public StringDiffer(String expected) {
        this.expected = expected;
    }

    @Override
    protected boolean matchesSafely(String actual) {
        for (String pattern : excludePatterns) {
            expected = expected.replaceAll(pattern, "");
            actual = actual.replaceAll(pattern, "");
        }
        return expected.equals(actual);
    }

    @Override
    protected void describeMismatchSafely(String actual, Description mismatchDescription) {
        for (String pattern : excludePatterns) {
            expected = expected.replaceAll(pattern, "");
            actual = actual.replaceAll(pattern, "");
        }
        DifferWithPrettidiff diff = new DifferWithPrettidiff(expected, actual);

        mismatchDescription.appendText("Строки различаются - ");
        String url = elliptics().path(this.getClass()).randomize().name("prettydiff.htm")
                .put(diff.getHtml())
                .get().url();
        mismatchDescription.appendText(link(url, "DIFF")).appendText("\n");
        mismatchDescription.appendText(html(accordeon("Actual", actual)));
        mismatchDescription.appendText(html(accordeon("DIFF", iframe(url))));
    }

    @Override
    public void describeTo(Description description) {
        description.appendText(html(accordeon("Expected", expected)));
    }

    public static StringDiffer notDiffersWith(String expected) {
        return new StringDiffer(expected);
    }

    public StringDiffer exclude(String pattern) {
        excludePatterns.add(pattern);
        return this;
    }

    public StringDiffer excludeDefaults() {
        String patternTimestamp = "\"timestamp\":(\\d+)";
        String patternTimerLogic = "\"timer_logic\":\"(\\d+)\"";
        String patternTimerDb = "\"timer_db\":\"(\\d+)\"";
        //ревизия треда
        String patternTscn = "\"tscn\":\"(\\d+)\"";
        String patternCkey = "\"ckey\":\".{44}\"";
        String patternJane = "\"jane\":\".{6,12}\"";

        return this.exclude(" ")
                .exclude("\r")
                .exclude("\n")
                .exclude(patternTimestamp)
                .exclude(patternTimerLogic)
                .exclude(patternTimerDb)
                .exclude(patternJane)
                .exclude(patternCkey)
                .exclude(patternTscn);
    }
}
