package ru.yandex.autotests.innerpochta.wmi.core.matchers;

import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 20.03.13
 * Time: 20:21
 */
public class StringResponseOperMatcher extends FeatureMatcher<Oper, String> {
    public StringResponseOperMatcher(Matcher<? super String> subMatcher) {
        super(subMatcher, "ответ операции", "");
    }

    @Override
    protected String featureValueOf(Oper actual) {
        return actual.toString();
    }

    public static StringResponseOperMatcher hasStringContent(Matcher<? super String> subMatcher) {
        return new StringResponseOperMatcher(subMatcher);
    }
}
