package ru.yandex.autotests.innerpochta.wmi.core.matchers.barbet;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.beans.hound.ArchiveState;
import ru.yandex.autotests.innerpochta.beans.hound.ArchiveStatus;
import ru.yandex.autotests.innerpochta.wmi.core.hound.v2.archivestatus.ApiArchiveStatus;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;

import java.util.Objects;

import static ru.yandex.autotests.innerpochta.wmi.core.api.CommonApiSettings.shouldBe;
import static ru.yandex.autotests.innerpochta.wmi.core.api.WmiApis.apiHoundV2;
import static ru.yandex.autotests.innerpochta.wmi.core.barbet.BarbetResponses.ok200;


public class ArchiveMatcher {

    public static ArchiveStatus getArchiveStatus(HttpClientManagerRule rule) {
        return apiHoundV2(rule.account().userTicket())
                .archiveStatus()
                .withUid(rule.account().uid())
                .withDbtype(ApiArchiveStatus.DbtypeParam.MASTER)
                .get(shouldBe(ok200()))
                .as(ArchiveStatus.class);
    }


    @Factory
    public static TypeSafeMatcher<HttpClientManagerRule> archiveIsInState(final ArchiveState archiveState) {
        return new TypeSafeMatcher<HttpClientManagerRule>() {
            @Override
            protected boolean matchesSafely(HttpClientManagerRule rule) {
                ArchiveStatus status = getArchiveStatus(rule);
                return !Objects.isNull(status) && Objects.equals(status.getArchiveState(), archiveState);
            }

            @Override
            public void describeTo(Description description) {
                description
                        .appendText("Ожидается, что архив в состоянии: ")
                        .appendValue(archiveState);
            }
        };
    }
}

