package ru.yandex.autotests.innerpochta.wmi.core.matchers.barbet;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.beans.barbet.Additional;
import ru.yandex.autotests.innerpochta.beans.barbet.Primary;
import ru.yandex.autotests.innerpochta.beans.barbet.Restore;
import ru.yandex.autotests.innerpochta.beans.barbet.Status;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;

import static ru.yandex.autotests.innerpochta.wmi.core.api.WmiApis.apiBarbet;
import static ru.yandex.autotests.innerpochta.wmi.core.api.CommonApiSettings.shouldBe;
import static ru.yandex.autotests.innerpochta.wmi.core.barbet.BarbetResponses.ok200;


public class BackupMatcher {
    @Factory
    public static TypeSafeMatcher<HttpClientManagerRule> activeBackupWithId(final Long backupId) {
        return new TypeSafeMatcher<HttpClientManagerRule>() {
            @Override
            protected boolean matchesSafely(HttpClientManagerRule rule) {
                Primary backup = apiBarbet(rule.account().userTicket())
                        .status()
                        .withUid(rule.account().uid())
                        .get(shouldBe(ok200()))
                        .as(Status.class)
                        .getPrimary();

                return backup != null && backup.getBackupId().equals(backupId);
            }

            @Override
            public void describeTo(Description description) {
                description.appendText("Ожидается активный бекап id: ")
                        .appendValue(backupId);
            }
        };
    }

    @Factory
    public static TypeSafeMatcher<HttpClientManagerRule> backupIsInProgress() {
        return new TypeSafeMatcher<HttpClientManagerRule>() {
            @Override
            protected boolean matchesSafely(HttpClientManagerRule rule) {
                Additional backup = apiBarbet(rule.account().userTicket())
                        .status()
                        .withUid(rule.account().uid())
                        .get(shouldBe(ok200()))
                        .as(Status.class)
                        .getAdditional();

                return backup != null && backup.getState().equals("in_progress");
            }

            @Override
            public void describeTo(Description description) {
                description.appendText("Ожидается создающийся бекап");
            }
        };
    }

    @Factory
    public static TypeSafeMatcher<HttpClientManagerRule> emptyActiveBackup() {
        return new TypeSafeMatcher<HttpClientManagerRule>() {
            @Override
            protected boolean matchesSafely(HttpClientManagerRule rule) {
                Primary backup = apiBarbet(rule.account().userTicket())
                        .status()
                        .withUid(rule.account().uid())
                        .get(shouldBe(ok200()))
                        .as(Status.class)
                        .getPrimary();

                return backup == null;
            }

            @Override
            public void describeTo(Description description) {
                description.appendText("Ожидается отсутствие активного бекапа");
            }
        };
    }

    @Factory
    public static TypeSafeMatcher<HttpClientManagerRule> completeRestore(final Long backupId) {
        return new TypeSafeMatcher<HttpClientManagerRule>() {
            @Override
            protected boolean matchesSafely(HttpClientManagerRule rule) {
                Restore restore = apiBarbet(rule.account().userTicket())
                        .status()
                        .withUid(rule.account().uid())
                        .get(shouldBe(ok200()))
                        .as(Status.class)
                        .getRestore();

                return restore != null && restore.getState().equals("complete") && restore.getBackupId().equals(backupId);
            }

            @Override
            public void describeTo(Description description) {
                description.appendText("Ожидается успешный рестор для бекапа id: ")
                        .appendValue(backupId);
            }
        };
    }
}
