package ru.yandex.autotests.innerpochta.wmi.core.matchers.folders;

import org.apache.http.impl.client.DefaultHttpClient;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import ru.yandex.autotests.innerpochta.wmi.core.oper.FolderList;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 04.04.13
 * Time: 13:19
 */
public class FolderMatchers {

    public static Matcher<DefaultHttpClient> hasSpecialValue(final String fid, Matcher<String> matcher) {
        return new FeatureMatcher<DefaultHttpClient, String>(matcher,
                String.format("Значение SPECIAL для папки с фидом <%s>", fid), "sp: ") {
            @Override
            protected String featureValueOf(DefaultHttpClient hc) {
                return jsx(FolderList.class).post().via(hc).getSpecial(fid);
            }
        };
    }

    public static Matcher<DefaultHttpClient> hasSymbol(final String fid, Matcher<String> matcher) {
        return new FeatureMatcher<DefaultHttpClient, String>(matcher,
                String.format("Значение SYMBOL для папки с фидом <%s>", fid), "symbol: ") {
            @Override
            protected String featureValueOf(DefaultHttpClient hc) {
                return jsx(FolderList.class).post().via(hc).getSymbol(fid);
            }
        };
    }
}
