package ru.yandex.autotests.innerpochta.wmi.core.matchers.folders;

import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import ru.yandex.autotests.innerpochta.wmi.core.oper.hound.Folders;
import ru.yandex.autotests.innerpochta.wmi.core.oper.hound.Hound;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;

import java.util.Optional;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

public class FoldersMatchers {
    public static Matcher<HttpClientManagerRule> hasSymbol(final String fid, Matcher<String> matcher) {
        return new FeatureMatcher<HttpClientManagerRule, String>(matcher,
                String.format("Значение SYMBOL для папки с фидом <%s>", fid), "symbol: ") {
            @Override
            protected String featureValueOf(HttpClientManagerRule hc) {
                return Optional.ofNullable(Hound.folders(hc)
                        .get(fid))
                        .map(f -> f.getSymbolicName().getTitle())
                        .orElse("");
            }
        };
    }
}
