package ru.yandex.autotests.innerpochta.wmi.core.matchers.folders;

import org.apache.http.impl.client.DefaultHttpClient;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.wmi.core.oper.FolderList;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;

public class IsThereCustomFolderMatcher extends TypeSafeMatcher<DefaultHttpClient> {
    private int count = 0;

    @Factory
    public static IsThereCustomFolderMatcher hasCustomFolders() {
        return new IsThereCustomFolderMatcher();
    }

    @Override
    protected boolean matchesSafely(DefaultHttpClient hc) {
        try {
            count = api(FolderList.class).post().via(hc).getAllFolderIdsWithoutSystem().size();
            return count > 0;
        } catch (Exception e) {
            throw new RuntimeException("Невозможно получить список папок", e);
        }
    }

    @Override
    protected void describeMismatchSafely(DefaultHttpClient hc, Description mismatchDescription) {
        mismatchDescription.appendText(String.format("\nНайдено %d пользовательских папок", count));
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("наличие пользовательских папок");
    }
}
