package ru.yandex.autotests.innerpochta.wmi.core.matchers.folders;

import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.beans.folderlist.Symbol;
import ru.yandex.autotests.innerpochta.beans.yplatform.Folder;
import ru.yandex.autotests.innerpochta.wmi.core.obj.hound.FoldersObj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.hound.Folders;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;
import ru.yandex.autotests.innerpochta.wmi.core.utils.FolderList;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class IsThereFolder {
    private static final String SEPARATOR = "|";

    public static TypeSafeMatcher<HttpClientManagerRule> hasFolder(final String name) {
        return new TypeSafeMatcher<HttpClientManagerRule>() {
            @Override
            protected boolean matchesSafely(HttpClientManagerRule rule) {
                return new FolderList(rule).fidByName(name) != null;
            }

            @Override
            public void describeTo(Description description) {
                description.appendText(String.format("наличие папки с именем '%s' ", name));
            }
        };
    }

    public static TypeSafeMatcher<HttpClientManagerRule> hasSubfolder(final String childName, final String parentName) {
        return hasFolder(parentName + SEPARATOR + childName);
    }

    public static TypeSafeMatcher<HttpClientManagerRule> hasFolderWithFids(final List<String> fids) {
        return new TypeSafeMatcher<HttpClientManagerRule>() {
            @Override
            protected boolean matchesSafely(HttpClientManagerRule rule) {
                return new FolderList(rule).folders().keySet().containsAll(fids);
            }

            @Override
            public void describeTo(Description description) {
                description.appendText(String.format("наличие папok с фидами <%s> ", String.join(",", fids)));
            }
        };
    }

    public static TypeSafeMatcher<HttpClientManagerRule> hasFolderWithFid(final String fid) {
        return hasFolderWithFids(Collections.singletonList(fid));
    }

    public static TypeSafeMatcher<HttpClientManagerRule> hasFolderWithNameAndSymbol(final String name, final Symbol symbol) {
        return new TypeSafeMatcher<HttpClientManagerRule>() {
            @Override
            protected boolean matchesSafely(HttpClientManagerRule rule) {
                return new FolderList(rule).folders()
                        .entrySet()
                        .stream()
                        .anyMatch(f -> f.getValue().getName().equals(name) &&
                                f.getValue().getSymbolicName().getTitle().equals(symbol.toString()));
            }

            @Override
            public void describeTo(Description description) {
                description.appendText(String.format("наличие папки с именем '%s' ", name))
                        .appendText(String.format("и символом '%s' ", symbol));
            }
        };
    }

    public static TypeSafeMatcher<HttpClientManagerRule> hasFolderWithSymbol(final String fid, final Symbol symbol) {
        return new TypeSafeMatcher<HttpClientManagerRule>() {
            @Override
            protected boolean matchesSafely(HttpClientManagerRule rule) {
                return new FolderList(rule).folders()
                        .get(fid)
                        .getSymbolicName()
                        .getTitle().equals(symbol.toString());
            }

            @Override
            public void describeTo(Description description) {
                description.appendText(String.format("наличие папки с символом '%s' ", symbol));
            }
        };
    }

    public static TypeSafeMatcher<HttpClientManagerRule> hasOrder(final List<String> order) {
        return new TypeSafeMatcher<HttpClientManagerRule>() {
            private boolean compare(Folder a, Folder b) {
                if (b == null) {
                    return true;
                }

                return a.getPosition() < b.getPosition();
            }

            @Override
            protected boolean matchesSafely(HttpClientManagerRule rule) {
                Map<String, Folder> folders = Folders.folders(
                        FoldersObj.empty()
                                .setUid(rule.account().uid())
                )
                        .get()
                        .via(rule)
                        .folders();

                for(int i = 0; i < order.size()-1; i++) {
                    if (!compare(folders.get(order.get(i)), folders.get(order.get(i+1)))) {
                        return false;
                    }
                }

                return true;
            }

            @Override
            public void describeTo(Description description) {
                description.appendValueList("Папки будут идти в такой последовательности: " +
                        "\n----->", "\n----->", "", order);
            }
        };
    }
}
