package ru.yandex.autotests.innerpochta.wmi.core.matchers.folders;

import org.apache.http.impl.client.DefaultHttpClient;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.wmi.core.oper.FolderList;

import java.util.ArrayList;
import java.util.List;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 25.11.13
 * Time: 13:41
 */
public class IsThereFolderWithFidsMatcher extends TypeSafeMatcher<DefaultHttpClient> {

    private List<String> fidsToCheck = new ArrayList<>();
    private List<String> actualFids;

    public IsThereFolderWithFidsMatcher(String fid) {
        this.fidsToCheck.add(fid);
    }

    public IsThereFolderWithFidsMatcher(List<String> fids) {
        this.fidsToCheck.addAll(fids);
    }

    @Factory
    public static IsThereFolderWithFidsMatcher hasFolderWithFid(String fid) {
        return new IsThereFolderWithFidsMatcher(fid);
    }

    @Factory
    public static IsThereFolderWithFidsMatcher hasFoldersWithFids(List<String> fids) {
        return new IsThereFolderWithFidsMatcher(fids);
    }

    @Override
    protected boolean matchesSafely(DefaultHttpClient hc) {
        FolderList folderList = null;
        try {
            folderList = api(FolderList.class).post().via(hc);
            actualFids = folderList.getAllFolderIds();
        } catch (Exception e) {
            throw new RuntimeException("Невозможно достать папки пользователя", e);
        }

        return actualFids.containsAll(fidsToCheck);
    }

    @Override
    protected void describeMismatchSafely(DefaultHttpClient hc, Description mismatchDescription) {
        mismatchDescription.appendValueList("\nНайдены папки: \n----->", "\n----->", "", actualFids);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText(String.format("наличие папok с фидами <%s> ", String.join(",", fidsToCheck)));
    }
}
