package ru.yandex.autotests.innerpochta.wmi.core.matchers.folders;

import lombok.val;
import org.apache.http.impl.client.DefaultHttpClient;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.beans.folderlist.Symbol;
import ru.yandex.autotests.innerpochta.wmi.core.oper.FolderList;

import java.util.List;

import static java.util.Arrays.asList;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 7/11/13
 * Time: 6:13 PM
 */
public class IsThereFolderWithNameMatcher extends TypeSafeMatcher<DefaultHttpClient> {

    private String name;
    private Symbol symbol;
    private List<String> names;

    public IsThereFolderWithNameMatcher(String name) {
        this(name, null);
    }

    public IsThereFolderWithNameMatcher(String name, Symbol symbol) {
        this.name = name;
        this.symbol = symbol;
    }

    @Factory
    public static IsThereFolderWithNameMatcher hasFolder(String name) {
        return new IsThereFolderWithNameMatcher(name);
    }

    @Factory
    public static IsThereFolderWithNameMatcher hasFolderWithSymbol(String name, Symbol symbol) {
        return new IsThereFolderWithNameMatcher(name, symbol);
    }

    @Override
    protected boolean matchesSafely(DefaultHttpClient hc) {
        try {
            FolderList folderList = api(FolderList.class).post().via(hc);
            if (symbol != null) {
                val nameBySymbol = folderList.nameBySymbolOrNull(symbol);
                if (nameBySymbol != null) {
                    names = asList(nameBySymbol);
                    return name.equals(nameBySymbol);
                } else {
                    return false;
                }
            } else {
                names = folderList.getAllFolderNames();
                return names.contains(name);
            }
        } catch (Exception e) {
            throw new RuntimeException("Невозможно найти папку", e);
        }
    }

    @Override
    protected void describeMismatchSafely(DefaultHttpClient hc, Description mismatchDescription) {
        if (symbol != null) {
            mismatchDescription.appendValueList(String.format("\nНайдены папки с меткой '%s': \n----->", symbol),
                    "\n----->", "", names);
        } else {
            mismatchDescription.appendValueList("\nНайдены папки: \n----->", "\n----->", "", names);
        }
    }

    @Override
    public void describeTo(Description description) {
        description.appendText(String.format("наличие папки с именем '%s' ", name));
        if (symbol != null) {
            description.appendText(String.format("и символом '%s' ", symbol));
        }
    }
}
