package ru.yandex.autotests.innerpochta.wmi.core.matchers.folders;

import org.apache.http.impl.client.DefaultHttpClient;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.wmi.core.oper.FolderList;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 7/11/13
 * Time: 6:13 PM
 */
public class IsThereSubfolderMatcher extends TypeSafeMatcher<DefaultHttpClient> {

    private String childName;
    private String parentName;

    public IsThereSubfolderMatcher(String childName,
                                   String parentName) {
        this.childName = childName;
        this.parentName = parentName;
    }

    @Factory
    public static IsThereSubfolderMatcher hasSubfolder(String childName,
                                                       String parentName) {
        return new IsThereSubfolderMatcher(childName, parentName);
    }

    @Override
    protected boolean matchesSafely(DefaultHttpClient hc) {
        return jsx(FolderList.class).post().via(hc)
                .isThereSubFolder(childName, parentName);
    }

    @Override
    protected void describeMismatchSafely(DefaultHttpClient hc, Description mismatchDescription) {
        mismatchDescription.appendText(String.format("в папке <%s> нет подпапки <%s>", parentName, childName));
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("наличие подпапки " + childName);
    }
}
