package ru.yandex.autotests.innerpochta.wmi.core.matchers.folders;

import org.apache.http.impl.client.DefaultHttpClient;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.wmi.core.oper.FolderList;

import java.util.List;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 7/21/13
 * Time: 3:13 PM
 */
public class PositionMatcher extends TypeSafeMatcher<DefaultHttpClient> {
    private List<String> order;

    private String firstItem;
    private String secondItem;

    private Integer firstPos = 0;
    private Integer secondPos = 0;

    private FolderList curr;


    public PositionMatcher(List<String> order) {
        this.order = order;
    }

    @Factory
    public static PositionMatcher hasOrder(List<String> expected) {
        return new PositionMatcher(expected);
    }

    /*
     метод возвращает true если firstPos < secondPos
     иначе false
     */
    private boolean comparePair(String firstItem, String secondItem) {
        if (secondItem == null) {
            return true;
        }
        try {
            String itemFidFirst = curr.getFolderId(firstItem);
            String itemFidSecond = curr.getFolderId(secondItem);

            firstPos = curr.getPosition(itemFidFirst);
            secondPos = curr.getPosition(itemFidSecond);

        } catch (Exception e) {
            throw new RuntimeException("Невозможно сравнить position", e);
        }
        return (firstPos < secondPos);
    }

    @Override
    protected boolean matchesSafely(DefaultHttpClient hc) {                       //TODO: сделать итератором
        curr = api(FolderList.class).post().via(hc);
        for (int i = 0; i < order.size() - 1; i++) {
            firstItem = order.get(i);
            secondItem = order.get(i + 1);
            if (!comparePair(firstItem, secondItem)) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void describeMismatchSafely(DefaultHttpClient item, Description mismatchDescription) {
        mismatchDescription.appendText(String.format("неправильные позиции имеют папки с именем: %s и %s, " +
                        "их position: %s и %s",
                firstItem, secondItem, firstPos, secondPos));
    }

    @Override
    public void describeTo(Description description) {
        description.appendValueList("папки будут идти в такой последовательности: " +
                "\n----->", "\n----->", "", order);

    }
}
