package ru.yandex.autotests.innerpochta.wmi.core.matchers.folders;

import org.apache.http.impl.client.DefaultHttpClient;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.wmi.core.oper.FolderList;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.filter.log.LoggerFilterBuilder.log;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 06.01.13
 * Time: 21:24
 */
public class RecentFolderMatcher extends TypeSafeMatcher<DefaultHttpClient> {

    private String fid;
    private String recent;
    private String getRecent;

    public RecentFolderMatcher(String fid, String recent) {
        this.fid = fid;
        this.recent = recent;
    }

    @Override
    protected boolean matchesSafely(DefaultHttpClient hc) {
        getRecent = api(FolderList.class)
                .log(log().body(false).respHeaders(false).status(false))
                .post().via(hc).getFolderRecentValue(fid);
        return getRecent.equals(recent);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("Ожидалось значение RECENT: ").appendValue(recent);
    }

    @Override
    protected void describeMismatchSafely(DefaultHttpClient item, Description mismatchDescription) {
        mismatchDescription.appendText("Получено RECENT: ").appendValue(getRecent);
    }


    @Factory
    public static RecentFolderMatcher hasRecent(String fid) {
        return new RecentFolderMatcher(fid, "1");
    }

    @Factory
    public static RecentFolderMatcher notHasRecent(String fid) {
        return new RecentFolderMatcher(fid, "0");
    }

}
