package ru.yandex.autotests.innerpochta.wmi.core.matchers.folders;

import org.apache.http.impl.client.DefaultHttpClient;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.beans.yplatform.Folder;
import ru.yandex.autotests.innerpochta.wmi.core.obj.hound.FoldersObj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.FolderList;
import ru.yandex.autotests.innerpochta.wmi.core.oper.hound.Folders;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;

import java.util.Optional;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;
import static ru.yandex.autotests.innerpochta.wmi.core.filter.log.LoggerFilterBuilder.log;
import static ru.yandex.autotests.innerpochta.wmi.core.oper.hound.Folders.folders;

public class RecentFoldersMatcher extends TypeSafeMatcher<HttpClientManagerRule> {

    private String fid;
    private String recent;
    private String getRecent;

    public RecentFoldersMatcher(String fid, String recent) {
        this.fid = fid;
        this.recent = recent;
    }

    @Override
    protected boolean matchesSafely(HttpClientManagerRule authClient) {
        getRecent = String.valueOf(folders(FoldersObj.empty().setUid(authClient.account().uid()))
                .get().via(authClient)
                .folders()
                .get(fid)
                .getRecentMessagesCount());
        return getRecent.equals(recent);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("Ожидалось значение RECENT: ").appendValue(recent);
    }

    @Override
    protected void describeMismatchSafely(HttpClientManagerRule item, Description mismatchDescription) {
        mismatchDescription.appendText("Получено RECENT: ").appendValue(getRecent);
    }


    @Factory
    public static RecentFoldersMatcher hasRecent(String fid) {
        return new RecentFoldersMatcher(fid, "1");
    }

    @Factory
    public static RecentFoldersMatcher notHasRecent(String fid) {
        return new RecentFoldersMatcher(fid, "0");
    }

}
