package ru.yandex.autotests.innerpochta.wmi.core.matchers.folders;

import org.apache.http.impl.client.DefaultHttpClient;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.wmi.core.obj.hound.FoldersObj;

import static ru.yandex.autotests.innerpochta.wmi.core.oper.hound.Folders.folders;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 23.10.15
 * Time: 18:26
 */
public class UnvisitedFolderMatcher extends TypeSafeMatcher<DefaultHttpClient> {

    private String fid;
    private Boolean unvisited;
    private Boolean getUnvisited;
    private String uid;

    public UnvisitedFolderMatcher(String fid, String uid, Boolean unvisited) {
        this.fid = fid;
        this.uid = uid;
        this.unvisited = unvisited;
    }

    @Override
    protected boolean matchesSafely(DefaultHttpClient hc) {
        getUnvisited = folders(FoldersObj.empty()
                .setUid(uid)).get().via(hc).getUnvisited(fid);
        return getUnvisited.equals(unvisited);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("Ожидалось значение RECENT: ").appendValue(unvisited);
    }

    @Override
    protected void describeMismatchSafely(DefaultHttpClient item, Description mismatchDescription) {
        mismatchDescription.appendText("Получено RECENT: ").appendValue(getUnvisited);
    }


    @Factory
    public static UnvisitedFolderMatcher hasUnvisited(String fid, String uid) {
        return new UnvisitedFolderMatcher(fid, uid, true);
    }

    @Factory
    public static UnvisitedFolderMatcher notHasUnvisited(String fid, String uid) {
        return new UnvisitedFolderMatcher(fid, uid, false);
    }

}