package ru.yandex.autotests.innerpochta.wmi.core.matchers.folders;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.wmi.core.obj.hound.FoldersObj;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;

import static ru.yandex.autotests.innerpochta.wmi.core.oper.hound.Folders.folders;

public class UnvisitedFoldersMatcher extends TypeSafeMatcher<HttpClientManagerRule> {

    private String fid;
    private Boolean unvisited;
    private Boolean getUnvisited;

    private UnvisitedFoldersMatcher(String fid, Boolean unvisited) {
        this.fid = fid;
        this.unvisited = unvisited;
    }

    @Override
    protected boolean matchesSafely(HttpClientManagerRule authClient) {
        getUnvisited = folders(FoldersObj.empty().setUid(authClient.account().uid()))
                .get().via(authClient)
                .folders()
                .get(fid)
                .getUnvisited();
        return getUnvisited.equals(unvisited);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("Ожидалось значение UNVISITED: ").appendValue(unvisited);
    }

    @Override
    protected void describeMismatchSafely(HttpClientManagerRule item, Description mismatchDescription) {
        mismatchDescription.appendText("Получено UNVISITED: ").appendValue(getUnvisited);
    }


    @Factory
    public static UnvisitedFoldersMatcher hasUnvisited(String fid) {
        return new UnvisitedFoldersMatcher(fid, true);
    }

    @Factory
    public static UnvisitedFoldersMatcher notHasUnvisited(String fid) {
        return new UnvisitedFoldersMatcher(fid,false);
    }

}