package ru.yandex.autotests.innerpochta.wmi.core.matchers.labels;

import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.LogManager;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.wmi.core.obj.hound.LabelsObj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.hound.Labels;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;


public class CountLidsMatcher extends TypeSafeMatcher<HttpClientManagerRule> {
    private Matcher<Integer> expected;
    private String lid;

    public CountLidsMatcher(Matcher<Integer> expected, String lid) {
        this.expected = expected;
        this.lid = lid;
    }

    @Override
    protected boolean matchesSafely(HttpClientManagerRule rule) {
        int count = Labels.labels(
                LabelsObj
                        .empty()
                        .setUid(rule.account().uid()))
                .get()
                .via(rule)
                .countByLid(lid)
                .orElse(0l)
                .intValue();

        LogManager.getLogger("WAIT4DELIVER").info("Сообщений " + expected + " / " + count + " помечены меткой - '" + lid + "'");

        return expected.matches(count);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("Ожидалось сообщений - ")
                .appendDescriptionOf(expected);
    }

    @Factory
    public static CountLidsMatcher hasCountLabelsWithLid(Matcher<Integer> count, String lid) {
        return new CountLidsMatcher(count, lid);
    }
}