package ru.yandex.autotests.innerpochta.wmi.core.matchers.labels;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.beans.yplatform.Lid;
import ru.yandex.autotests.innerpochta.wmi.core.obj.hound.LabelsObj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.hound.Labels;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;

import java.util.Map;
import java.util.stream.Stream;


public class IsThereLabel {
    @Factory
    public static TypeSafeMatcher<HttpClientManagerRule> hasLabel(final String lid) {
        return new TypeSafeMatcher<HttpClientManagerRule>() {
            @Override
            public void describeTo(Description description) {
                description.appendText("Наличие метки ").appendText(lid);
            }

            @Override
            protected boolean matchesSafely(HttpClientManagerRule rule) {
                return Labels.labels(
                        LabelsObj.empty()
                            .setUid(rule.account().uid())
                )
                        .get()
                        .via(rule)
                        .labels()
                        .keySet()
                        .contains(lid);
            }
        };
    }

    private static Stream<Map.Entry<String, Lid>> getLabels(HttpClientManagerRule rule) {
        return Labels.labels(
                LabelsObj.empty()
                        .setUid(rule.account().uid())
        )
                .get()
                .via(rule)
                .labels()
                .entrySet()
                .stream();
    }

    @Factory
    public static TypeSafeMatcher<HttpClientManagerRule> hasLabelName(final String name) {
        return new TypeSafeMatcher<HttpClientManagerRule>() {
            @Override
            public void describeTo(Description description) {
                description.appendText("Наличие метки ").appendText(name);
            }

            @Override
            protected boolean matchesSafely(HttpClientManagerRule rule) {
                return getLabels(rule)
                        .anyMatch(l -> l.getValue().getName().equals(name));
            }
        };
    }

    @Factory
    public static TypeSafeMatcher<HttpClientManagerRule> hasLabelByNameAndColor(final String name, final String color) {
        return new TypeSafeMatcher<HttpClientManagerRule>() {
            @Override
            public void describeTo(Description description) {
                description.appendText("Наличие метки ").appendText(name);
            }

            @Override
            protected boolean matchesSafely(HttpClientManagerRule rule) {
                return getLabels(rule)
                        .anyMatch(l -> l.getValue().getName().equals(name) &&
                                       l.getValue().getColor().equals(color));
            }
        };
    }
}
