package ru.yandex.autotests.innerpochta.wmi.core.matchers.labels;

import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.LogManager;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Labels;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 06.01.13
 * Time: 22:49
 */
public abstract class LabelCreatedMatcher extends TypeSafeMatcher<DefaultHttpClient> {

    public static final String NAME_COLOR = "с именем - '%s' и цветом '%s'";
    public static final String NAME = "с именем - '%s'";
    public static final String LID = "с LID - '%s'";

    private String comment = "";


    private LabelCreatedMatcher() {
    }

    public LabelCreatedMatcher comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Override
    protected boolean matchesSafely(DefaultHttpClient hc) {
        LogManager.getLogger(this.getClass()).info("Ищем метку " + comment);
        Labels labels = jsx(Labels.class).post().via(hc);
        return typeOfCheck(labels);
    }

    protected abstract Boolean typeOfCheck(Labels labels);

    @Override
    public void describeTo(Description description) {
        description.appendText("наличие метки ")
                .appendText(comment);
    }

    @Override
    protected void describeMismatchSafely(DefaultHttpClient item, Description mismatchDescription) {
        mismatchDescription.appendText("Такой метки не найдено");
    }


    @Factory
    public static LabelCreatedMatcher hasLabelLid(final String lid) {
        return new LabelCreatedMatcher() {
            @Override
            protected Boolean typeOfCheck(Labels labels) {
                return labels.isThereLabelWithSuchId(lid);
            }
        }.comment(String.format(LID, lid));
    }

    @Factory
    public static LabelCreatedMatcher hasLabelName(final String name) {
        return new LabelCreatedMatcher() {
            @Override
            protected Boolean typeOfCheck(Labels labels) {
                return labels.isThereLabelWithSuchName(name);
            }
        }.comment(String.format(NAME, name));
    }


    @Factory
    public static LabelCreatedMatcher hasLabel(final String name, final String color) {
        return new LabelCreatedMatcher() {
            @Override
            protected Boolean typeOfCheck(Labels labels) {
                return labels.isThereLabel(name, color);
            }
        }.comment(String.format(NAME_COLOR, name, color));
    }
}
