package ru.yandex.autotests.innerpochta.wmi.core.matchers.labels;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.LogManager;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.wmi.core.obj.MailBoxListObj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.FolderList;
import ru.yandex.autotests.innerpochta.wmi.core.oper.MailBoxList;
import ru.yandex.autotests.innerpochta.wmi.core.oper.ThreadsView;

import java.io.IOException;
import java.util.List;

import static java.lang.String.format;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;
import static ru.yandex.autotests.innerpochta.wmi.core.filter.log.LoggerFilterBuilder.log;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 06.01.13
 * Time: 21:24
 */
public class MessagesWithLabelMatcher extends TypeSafeMatcher<DefaultHttpClient> {
    private String fid;
    private String lid;

    private String folderName = "Входящие";


    public MessagesWithLabelMatcher(String lid, String fid) {
        this.lid = lid;
        this.fid = fid;
    }

    @Override
    protected boolean matchesSafely(DefaultHttpClient hc) {
        MailBoxListObj mbobj = MailBoxListObj.empty();
        MailBoxList mboxOper = jsx(MailBoxList.class).params(mbobj);

        if (null != fid) {
            mbobj.setSortType(MailBoxListObj.SORT_DATE);
            mbobj.setCurrentFolder(fid);

            folderName = api(FolderList.class).log(log().onlyIfError()).post().via(hc).getFolderName(fid);
        }

        //*** Логирование ------------------------------------------------------------------------------
        LogManager.getLogger("WAIT4LABELLING")
                .info(format("Ищем сообщения с меткой: '%s' - в папке - '%s' (%s)",
                        lid, folderName, StringUtils.defaultIfEmpty(fid, "...")));
        //----------------------------------------------------------------------------------------------

        return mboxOper.post().via(hc).isThereAnyMessageWithSuchLabel(lid);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("наличие писем с меткой ").appendValue(lid)
                .appendText(" в папке ")
                .appendValue(folderName)
                .appendText(" (")
                .appendText(StringUtils.defaultIfEmpty(fid, "..."))
                .appendText(")");
    }

    @Override
    protected void describeMismatchSafely(DefaultHttpClient item, Description mismatchDescription) {
        mismatchDescription.appendText("Сообщений с этой меткой не найдено");
    }

    @Factory
    public static MessagesWithLabelMatcher hasMessagesWithLabelIn(String lid, String fid) {
        return new MessagesWithLabelMatcher(lid, fid);
    }

    @Factory
    public static MessagesWithLabelMatcher hasMessagesWithLabel(String lid) {
        return new MessagesWithLabelMatcher(lid, null);
    }

    @Factory
    public static Matcher<DefaultHttpClient> hasThreadWithLabels(final String subject,
                                                                 Matcher<Iterable<? super String>> iterableMatcher) {
        return new TypeSafeMatcher<DefaultHttpClient>() {
            private List<String> lids;

            @Override
            protected boolean matchesSafely(DefaultHttpClient hc) {
                try {
                    ThreadsView respThrView = jsx(ThreadsView.class).post().via(hc);
                    String threadId = respThrView.getThreadId(subject);
                    lids = respThrView.threadLids(threadId);

                    return iterableMatcher.matches(lids);
                } catch (Exception e) {
                    throw new IllegalStateException("Не смогли получить треды", e);
                }
            }

            @Override
            public void describeTo(Description description) {
                description.appendText(format("тред %s со списком уникальных меток ", subject))
                        .appendDescriptionOf(iterableMatcher);
            }

            @Override
            protected void describeMismatchSafely(DefaultHttpClient item, Description mismatchDescription) {
                mismatchDescription.appendText("на треде найдены - ").appendValueList("[", ", ", "]", lids);
            }
        };
    }

}
