package ru.yandex.autotests.innerpochta.wmi.core.matchers.labels;

import org.apache.http.impl.client.DefaultHttpClient;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.CombinableMatcher;
import org.hamcrest.core.IsAnything;
import ru.yandex.autotests.innerpochta.wmi.core.obj.MailBoxListObj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.MailBoxList;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;
import static ru.yandex.autotests.innerpochta.wmi.core.filter.log.LoggerFilterBuilder.log;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 06.01.13
 * Time: 21:24
 */
public class MidHasLabelMatcher extends TypeSafeMatcher<DefaultHttpClient> {

    private MailBoxList oper = jsx(MailBoxList.class);
    private List<String> lids;
    private String mid;
    private String fid;

    public MidHasLabelMatcher(String mid, List<String> lids) {
        this.lids = lids;
        this.mid = mid;
    }

    public MidHasLabelMatcher(String mid, String fid, List<String> lids) {
        this.lids = lids;
        this.mid = mid;
        this.fid = fid;
    }

    public MidHasLabelMatcher with(MailBoxList oper) {
        this.oper = oper;
        return this;
    }

    @Override
    protected boolean matchesSafely(DefaultHttpClient hc) {
        MailBoxList resp;
        if (fid == null) {
            resp = oper.get().via(hc);
        } else {
            resp = oper.params(new MailBoxListObj().setCurrentFolder(fid))
                    .log(log().onlyIfErrorOrXmlWithError()).get().via(hc);
        }

        return resp.isMessageLabeled(mid, lids);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("должны быть метки: ")
                .appendValueList("[", ", ", "]", lids).appendText(" на письме с mid - ").appendValue(mid);
    }

    @Override
    protected void describeMismatchSafely(DefaultHttpClient item, Description mismatchDescription) {
        try {
            mismatchDescription.appendText("на письме обнаружены метки: ")
                    .appendValueList("[", ", ", "]", oper.get().via(item).getLidsOfMsgWithMid(mid));
        } catch (Exception e) {
            throw new RuntimeException("Не могу получить список меток", e);
        }
    }

    @Factory
    public static MidHasLabelMatcher hasMsgWithLid(String mid, String lid) {
        return new MidHasLabelMatcher(mid, newArrayList(lid));
    }

    @Factory
    public static MidHasLabelMatcher hasMsgWithLids(String mid, List<String> lids) {
        return new MidHasLabelMatcher(mid, lids);
    }


    @Factory
    public static MidHasLabelMatcher hasMsgWithLids(String mid, String... lids) {
        return hasMsgWithLids(mid, Arrays.asList(lids));
    }


    @Factory
    public static Matcher<DefaultHttpClient> hasMsgsWithLids(List<String> mids, List<String> lids) {
        CombinableMatcher<DefaultHttpClient> both =
                new CombinableMatcher<>(
                        new IsAnything<>("каждое из писем с метками")
                );
        for (String mid : mids) {
            both = both.and(hasMsgWithLids(mid, lids));
        }
        return both;
    }

    @Factory
    public static Matcher<DefaultHttpClient> hasMsgsWithLid(List<String> mids, String lid) {
        CombinableMatcher<DefaultHttpClient> both =
                new CombinableMatcher<>(
                        new IsAnything<>("каждое из писем с меткой")
                );
        for (String mid : mids) {
            both = both.and(hasMsgWithLids(mid, lid));
        }
        return both;
    }

    @Factory
    public static Matcher<DefaultHttpClient> hasMsgsWithLidInFolder(List<String> mids, String fid, String lid) {
        CombinableMatcher<DefaultHttpClient> both =
                new CombinableMatcher<>(
                        new IsAnything<>("каждое из писем с меткой")
                );
        for (String mid : mids) {
            both = both.and(hasMsgWithLidsInFolder(mid, fid, lid));
        }
        return both;
    }

    @Factory
    public static MidHasLabelMatcher hasMsgWithLidInFolder(String mid, String fid, String lid) {
        return hasMsgWithLidsInFolder(mid, fid, Arrays.asList(lid));
    }

    @Factory
    public static MidHasLabelMatcher hasMsgWithLidsInFolder(String mid, String fid, String... lids) {
        return hasMsgWithLidsInFolder(mid, fid, Arrays.asList(lids));
    }

    @Factory
    public static MidHasLabelMatcher hasMsgWithLidsInFolder(String mid, String fid, List<String> lids) {
        return new MidHasLabelMatcher(mid, fid, lids);
    }

}
