package ru.yandex.autotests.innerpochta.wmi.core.matchers.labels;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.CombinableMatcher;
import org.hamcrest.core.IsAnything;
import ru.yandex.autotests.innerpochta.wmi.core.obj.hound.MessagesByLabelObj;
import ru.yandex.autotests.innerpochta.wmi.core.obj.hound.MessagesUnreadByFolderObj;
import ru.yandex.autotests.innerpochta.wmi.core.obj.hound.MessagesUnreadObj;
import ru.yandex.autotests.innerpochta.wmi.core.obj.hound.MessagesWithAttachesObj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.hound.MessagesByLabel;
import ru.yandex.autotests.innerpochta.wmi.core.oper.hound.MessagesUnread;
import ru.yandex.autotests.innerpochta.wmi.core.oper.hound.MessagesUnreadByFolder;
import ru.yandex.autotests.innerpochta.wmi.core.oper.hound.MessagesWithAttaches;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;

import java.util.List;

import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.innerpochta.wmi.core.oper.hound.MessagesUnreadByFolder.messagesUnreadByFolder;
import static ru.yandex.autotests.innerpochta.wmi.core.oper.hound.MessagesByLabel.messagesByLabel;
import static ru.yandex.autotests.innerpochta.wmi.core.oper.hound.MessagesUnread.messagesUnread;
import static ru.yandex.autotests.innerpochta.wmi.core.oper.hound.MessagesWithAttaches.messagesWithAttaches;



public class MidsWithLabelMatcher extends TypeSafeMatcher<HttpClientManagerRule> {
    private final String lid;
    private final String mid;
    private final String fid;

    public MidsWithLabelMatcher(String mid, String lid) {
        this.lid = lid;
        this.mid = mid;
        this.fid = null;
    }

    public MidsWithLabelMatcher(String mid, String fid, String lid) {
        this.lid = lid;
        this.mid = mid;
        this.fid = fid;
    }

    private MessagesUnread unread(HttpClientManagerRule rule) {
            return messagesUnread(
                    MessagesUnreadObj.empty()
                            .setUid(rule.account().uid())
                            .setCount("30")
                            .setFirst("0")
            )
            .get()
            .via(rule);
    }

    private MessagesUnreadByFolder unreadByFolder(HttpClientManagerRule rule) {
            return messagesUnreadByFolder(
                    MessagesUnreadByFolderObj.empty()
                            .setUid(rule.account().uid())
                            .setCount("30")
                            .setFirst("0")
                            .setFid(fid)
            )
            .get()
            .via(rule);
    }

    private MessagesByLabel byLabel(HttpClientManagerRule rule) {
            return messagesByLabel(
                    MessagesByLabelObj
                            .empty()
                            .setUid(rule.account().uid())
                            .setLid(lid)
                            .setCount("30")
                            .setFirst("0")
            )
            .get()
            .via(rule);
    }

    private MessagesWithAttaches withAttaches(HttpClientManagerRule rule) {
            return messagesWithAttaches(
                    MessagesWithAttachesObj
                            .empty()
                            .setUid(rule.account().uid())
                            .setCount("30")
                            .setFirst("0")
            )
            .get()
            .via(rule);
    }

    @Override
    protected boolean matchesSafely(HttpClientManagerRule rule) {
        switch (lid) {
            case "FAKE_SEEN_LBL":
                return fid == null ? !unread(rule).hasMessage(mid)
                                   : !unreadByFolder(rule).hasMessage(mid, fid);
            case "FAKE_ATTACHED_LBL":
                return fid == null ? withAttaches(rule).hasMessage(mid)
                                   : withAttaches(rule).hasMessageInFolder(mid, fid);
            default:
                return fid == null ? byLabel(rule).hasMessageWithLid(mid)
                                   : byLabel(rule).hasMessageWithLidInFolder(mid, fid);
        }
    }

    @Override
    public void describeTo(Description description) {
        description
                .appendText("должны быть метки: ").appendText(lid)
                .appendText(" на письме с mid - ").appendValue(mid);
    }

    @Factory
    public static MidsWithLabelMatcher hasMsgWithLid(String mid, String lid) {
        return new MidsWithLabelMatcher(mid, lid);

    }

    @Factory
    public static MidsWithLabelMatcher hasMsgWithLidInFolder(String mid, String fid, String lid) {
        return new MidsWithLabelMatcher(mid, fid, lid);
    }

    @Factory
    public static Matcher<HttpClientManagerRule> hasMsgsWithLidInFolder(List<String> mids, String fid, String lid) {
        CombinableMatcher<HttpClientManagerRule> both =
                new CombinableMatcher<>(
                        new IsAnything<>("каждое из писем с меткой")
                );
        for (String mid : mids) {
            both = both.and(hasMsgWithLidInFolder(mid, fid, lid));
        }
        return both;

    }

    @Factory
    public static Matcher<HttpClientManagerRule> hasMsgsWithLid(List<String> mids, String lid) {
        CombinableMatcher<HttpClientManagerRule> both =
                new CombinableMatcher<>(
                        new IsAnything<>("каждое из писем с меткой")
                );
        for (String mid : mids) {
            both = both.and(hasMsgWithLid(mid, lid));
        }
        return both;
    }

    @Factory
    public static Matcher<HttpClientManagerRule> hasMsgsWithLids(List<String> mids, List<String> lids) {
        CombinableMatcher<HttpClientManagerRule> both =
                new CombinableMatcher<>(
                        new IsAnything<>("каждое из писем с меткой")
                );
        for (String mid : mids) {
            for (String lid : lids) {
                both = both.and(hasMsgWithLid(mid, lid));
            }
        }
        return both;
    }

    @Factory
    public static Matcher<HttpClientManagerRule> notHasMsgsWithLids(List<String> mids, List<String> lids) {
        CombinableMatcher<HttpClientManagerRule> both =
                new CombinableMatcher<>(
                        new IsAnything<>("каждое из писем без метки меткой")
                );
        for (String mid : mids) {
            for (String lid : lids) {
                both = both.and(not(hasMsgWithLid(mid, lid)));
            }
        }
        return both;
    }
}
