package ru.yandex.autotests.innerpochta.wmi.core.matchers.messages;

import org.apache.log4j.LogManager;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.wmi.core.obj.hound.FoldersObj;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;

import static ru.yandex.autotests.innerpochta.wmi.core.oper.hound.Folders.folders;

public class CountMessagesMatcher extends TypeSafeMatcher<HttpClientManagerRule> {
    private Matcher<Integer> expected;
    private String fid;

    public CountMessagesMatcher(Matcher<Integer> expected, String fid) {
        this.expected = expected;
        this.fid = fid;
    }

    @Override
    public void describeTo(Description description) {
        description
                .appendText("Ожидалось сообщений - ").appendDescriptionOf(expected)
                .appendText(" в папке: ").appendText(fid);
    }

    @Override
    protected boolean matchesSafely(HttpClientManagerRule rule) {
        Integer count = folders(
                    FoldersObj
                            .empty()
                            .setUid(rule.account().uid())
                            .withHidden()
                )
                .get()
                .via(rule)
                .count(fid);


        String msg = new StringBuilder()
                .append("Сообщений ")
                .append(expected)
                .append(" / ")
                .append(count)
                .append(" в папке - '")
                .append(fid)
                .append("'")
                .toString();

        LogManager.getLogger("WAIT4DELIVER").info(msg);


        return expected.matches(count);
    }

    @Factory
    public static CountMessagesMatcher hasCountMsgsIn(Matcher<Integer> count, String fid) {
        return new CountMessagesMatcher(count, fid);
    }
}
