package ru.yandex.autotests.innerpochta.wmi.core.matchers.messages;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.LogManager;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.wmi.core.oper.FolderList;

import static org.hamcrest.CoreMatchers.equalTo;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 06.08.14
 * Time: 17:10
 *
 * Матчер подходит для использования с большим количеством писем, в отличие от
 * IsThereMsgsMatcher, он не использует mailbox, а дергает folder_list.
 */
public class CountMsgsMatcher extends TypeSafeMatcher<DefaultHttpClient> {
    private Matcher<Integer> expected;
    private FolderList folderList;

    private Integer count;
    private String folderName;

    public CountMsgsMatcher(Matcher<Integer> expected) {
        this(expected, null);
    }

    public CountMsgsMatcher(Matcher<Integer> expected, String folderName) {
        this.expected = expected;
        this.folderName = folderName;
    }

    @Override
    protected boolean matchesSafely(DefaultHttpClient hc) {
        folderList = api(FolderList.class).post().via(hc);
        folderName = StringUtils.defaultIfEmpty(folderName, folderList.defaultName());
        count = folderList.getFolderCount(folderName);
        //*** Логирование ------------------------------------------------------------------------------
        LogManager.getLogger("WAIT4DELIVER").info("Сообщений "
                + expected + " / " + count + " в папке - '" + folderName
                + "' (" + StringUtils.defaultIfEmpty(folderList.getFolderId(folderName), "...") + ")");
        //----------------------------------------------------------------------------------------------
        return expected.matches(count);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("Ожидалось сообщений - ")
                .appendDescriptionOf(expected);
    }

    @Override
    protected void describeMismatchSafely(DefaultHttpClient item, Description mismatchDescription) {
        mismatchDescription.appendText("Обнаружено: ").appendValue(count)
                .appendText(" в папке ")
                .appendValue(folderName).appendText(" (").appendText(StringUtils.defaultIfEmpty(folderList.getFolderId(folderName), "..."))
                .appendText(")");
    }


    @Factory
    public static CountMsgsMatcher hasCountMsgs(Matcher<Integer> count) {
        return new CountMsgsMatcher(count);
    }

    @Factory
    public static CountMsgsMatcher hasCountMsgsIn(Matcher<Integer> count, String folderName) {
        return new CountMsgsMatcher(count, folderName);
    }

    @Factory
    public static CountMsgsMatcher hasNoMsgs() {
        return new CountMsgsMatcher(equalTo(0));
    }

    @Factory
    public static CountMsgsMatcher hasNoMsgsIn(String folderName) {
        return new CountMsgsMatcher(equalTo(0), folderName);
    }
}
