package ru.yandex.autotests.innerpochta.wmi.core.matchers.messages;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.LogManager;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.wmi.core.obj.MailBoxListObj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.FolderList;
import ru.yandex.autotests.innerpochta.wmi.core.oper.MailBoxList;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;
import static ru.yandex.autotests.innerpochta.wmi.core.filter.log.LoggerFilterBuilder.log;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 03.01.13
 * Time: 2:47
 */
public class IsThereMsgsMatcher extends TypeSafeMatcher<DefaultHttpClient> {
    private String subj;
    private Matcher<Integer> count;
    private String fid;

    private String folderName;

    private Integer counter = 0;

    public IsThereMsgsMatcher(String subj) {
        this(subj, equalTo(1));
    }

    public IsThereMsgsMatcher(String subj, Matcher<Integer> count) {
        this(subj, count, null);
    }

    public IsThereMsgsMatcher(String subj, Matcher<Integer> count, String fid) {
        this.subj = subj;
        this.count = count;
        this.fid = fid;
    }

    @Override
    protected boolean matchesSafely(DefaultHttpClient hc) {
        // В случае надобности, используем сообщение по-умолчанию
        MailBoxListObj mbobj = MailBoxListObj.empty();
        MailBoxList mboxOper = jsx(MailBoxList.class).params(mbobj);
        FolderList folderList;

        folderList = api(FolderList.class).log(log().onlyIfError()).post().via(hc);

        folderName = folderList.defaultName();

        if (null != fid) {
            mbobj.setSortType(MailBoxListObj.SORT_DATE);
            mbobj.setCurrentFolder(fid);
            folderName = folderList.getFolderName(fid);
        }

        MailBoxList resp = mboxOper.log(log().onlyIfError()).post().via(hc);
        if (subj == null) {
            counter = resp.countMessagesInFolder();
        } else {
            counter = resp.countMessagesInFolderWithSubj(subj);
        }

        //*** Логирование ------------------------------------------------------------------------------
        final String subjText = subj == null ? "" : subj;
        LogManager.getLogger("WAIT4DELIVER").info("Сообщений с темой: '" + subjText + "' - "
                + counter + " / " + count + " в папке - '" + folderName
                + "' (" + StringUtils.defaultIfEmpty(fid, "...") + ")");
        //----------------------------------------------------------------------------------------------

        if (count.matches(counter)) { // если нашли все
            //*** Логирование ----------------------------------------
            LogManager.getLogger("WAIT4DELIVER").info("All found ("
                    + counter + " / " + count + ")");
            //--------------------------------------------------------
            return true;
        }

        return false;
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("Ожидалось сообщений - ")
                .appendDescriptionOf(count);

        if (subj == null) {
            description.appendText(" без темы");
        } else {
            description.appendText(" с темой ")
                    .appendValue(subj);
        }
    }

    @Override
    protected void describeMismatchSafely(DefaultHttpClient item, Description mismatchDescription) {
        mismatchDescription.appendText("Обнаружено: ").appendValue(counter)
                .appendText(" в папке ")
                .appendValue(folderName).appendText(" (").appendText(StringUtils.defaultIfEmpty(fid, "..."))
                .appendText(")");
    }


    @Factory
    public static IsThereMsgsMatcher hasMsg(String subj) {
        return new IsThereMsgsMatcher(subj);
    }

    @Factory
    public static IsThereMsgsMatcher hasMsgIn(String subj, String fid) {
        return new IsThereMsgsMatcher(subj, equalTo(1), fid);
    }

    @Factory
    public static IsThereMsgsMatcher hasMsgs(String subj, Integer count) {
        return new IsThereMsgsMatcher(subj, equalTo(count));
    }

    @Factory
    public static IsThereMsgsMatcher hasMsgsIn(String subj, Integer count, String fid) {
        return new IsThereMsgsMatcher(subj, equalTo(count), fid);
    }

    @Factory
    public static IsThereMsgsMatcher hasMsgsIn(String subj, Matcher<Integer> count, String fid) {
        return new IsThereMsgsMatcher(subj, count, fid);
    }

    @Factory
    public static IsThereMsgsMatcher hasMsgsIn(String fid) {
        return new IsThereMsgsMatcher(null, greaterThan(0), fid);
    }

    @Factory
    public static IsThereMsgsMatcher hasMsgsIn(Integer count, String fid) {
        return new IsThereMsgsMatcher(null, equalTo(count), fid);
    }
}
