package ru.yandex.autotests.innerpochta.wmi.core.matchers.other;

import org.apache.http.impl.client.DefaultHttpClient;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.beans.mbody.Ping;

import static java.util.function.Function.identity;
import static ru.yandex.autotests.innerpochta.wmi.core.api.MbodyApi.apiMbody;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 27.04.16
 * Time: 20:28
 */
public class MbodyStatusMatcher extends TypeSafeMatcher<DefaultHttpClient> {
    private String result;

    @Factory
    public static MbodyStatusMatcher mbodyShouldSeePong() {
        return new MbodyStatusMatcher();
    }

    @Override
    protected boolean matchesSafely(DefaultHttpClient hc) {
        try {
            result = apiMbody().ping()
                .get(identity()).peek().as(Ping.class)
                .getPong();
            return result.isEmpty();
        } catch (Exception e) {
            return false;
        }
    }

    @Override
    protected void describeMismatchSafely(DefaultHttpClient hc, Description mismatchDescription) {
        mismatchDescription.appendText("Получили ответ: " + result);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("Наличие в ответе: \"\"");
    }
}
