package ru.yandex.autotests.innerpochta.wmi.core.matchers.other;

import org.apache.http.impl.client.DefaultHttpClient;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.wmi.core.oper.mops.Mops;

import static java.util.function.Function.identity;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 27.04.16
 * Time: 20:23
 */
public class MopsStatusMatcher extends TypeSafeMatcher<DefaultHttpClient> {
    private String result;

    @Factory
    public static MopsStatusMatcher mopsShouldSeePong() {
        return new MopsStatusMatcher();
    }

    @Override
    protected boolean matchesSafely(DefaultHttpClient hc) {
        try {
            return Mops.ping().get(identity()).asString().contains("ok");
        } catch (Exception e) {
            return false;
        }
    }

    @Override
    protected void describeMismatchSafely(DefaultHttpClient hc, Description mismatchDescription) {
        mismatchDescription.appendText("Получили ответ: " + result);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("Наличие в ответе: \"ok\"");
    }
}
