package ru.yandex.autotests.innerpochta.wmi.core.matchers.other;

import org.apache.http.impl.client.DefaultHttpClient;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Ping;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 27.04.16
 * Time: 19:16
 */
public class WmiStatusMatcher extends TypeSafeMatcher<DefaultHttpClient> {

    private String result;

    @Factory
    public static WmiStatusMatcher baidaShouldSeePong() {
        return new WmiStatusMatcher();
    }

    @Override
    protected boolean matchesSafely(DefaultHttpClient hc) {
        try {
            Ping ping = api(Ping.class).setHost(props().on8079Host()).get().via(hc);
            result = ping.getPong();
            return result.equals("pong");
        } catch (Exception e) {
            return false;
        }
    }

    @Override
    protected void describeMismatchSafely(DefaultHttpClient hc, Description mismatchDescription) {
        mismatchDescription.appendText("Получили ответ: " + result);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("Наличие в ответе: \"pong\"");
    }
}
