package ru.yandex.autotests.innerpochta.wmi.core.matchers.spaniel;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.beans.spaniel.Search;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;

import static ru.yandex.autotests.innerpochta.wmi.core.api.CommonApiSettings.shouldBe;
import static ru.yandex.autotests.innerpochta.wmi.core.api.WmiApis.apiSpaniel;
import static ru.yandex.autotests.innerpochta.wmi.core.spaniel.SpanielResponses.ok200;

public class SearchMather {
    @Factory
    public static TypeSafeMatcher<HttpClientManagerRule> searchIsComplete(String orgId, String adminUid, String searchId) {
        return new TypeSafeMatcher<HttpClientManagerRule>() {
            String searchState = "uninitialized";

            @Override
            protected boolean matchesSafely(HttpClientManagerRule rule) {
                Search search = apiSpaniel(rule.account().userTicket())
                        .search().show()
                        .withAdminUid(adminUid)
                        .withOrgId(orgId)
                        .withSearchId(searchId)
                        .get(shouldBe(ok200()))
                        .as(Search.class);

                if (search == null) {
                    return false;
                }

                searchState = search.getState();

                return searchState.equals("complete") || searchState.equals("partially_complete");
            }

            @Override
            public void describeTo(Description description) {
                description.appendText("Ожидается поиск в состоянии complete или partially_complete");
            }

            @Override
            protected void describeMismatchSafely(HttpClientManagerRule rule, Description mismatchDescription) {
                mismatchDescription.appendValue(searchState);
            }
        };
    }

}
