package ru.yandex.autotests.innerpochta.wmi.core.matchers.ssh;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.wmi.core.rules.SSHRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static ru.yandex.autotests.innerpochta.util.ssh.SSHCommands.executeCommAndResturnResultAsString;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 26.02.14
 * Time: 17:29
 * <p/>
 * Матчер нужен для грепа различных логов wmi.
 * Грепаем по всему логу
 *
 */
public class IsThereLogEntry extends TypeSafeMatcher<SSHRule> {

    protected final Logger logger = LogManager.getLogger(this.getClass());

    private String entry;
    private String pathToLog;
    private Matcher<Integer> matcher;

    public IsThereLogEntry(String pathToLog, String entry, Matcher<Integer> matcher) {
        this.pathToLog = pathToLog;
        this.entry = entry;
        this.matcher = matcher;
    }

    public String grepFromLog(SSHRule sshRule, String entry) {
        logger.warn(String.format("Ищем в логе %s строчку: <%s> ", pathToLog, entry));
        try {
            return executeCommAndResturnResultAsString(sshRule.conn(), String.format(
                    "less %s | grep -c '%s'", pathToLog, entry), logger);
        } catch (Exception e) {
            throw new RuntimeException("не удалось открыть лог для поиска записи ", e);
        }
    }

    @Factory
    public static IsThereLogEntry hasEntry(String pathToLog, String entry, Matcher<Integer> matcher) {
        return new IsThereLogEntry(pathToLog, entry, matcher);
    }

    @Factory
    public static IsThereLogEntry hasOneEntry(String pathToLog, String entry) {
        return new IsThereLogEntry(pathToLog, entry, equalTo(1));
    }


    @Override
    protected boolean matchesSafely(SSHRule sshRule) {
        Integer result = Integer.parseInt(
                StringUtils.chomp(grepFromLog(sshRule, entry)));
        return matcher.matches(result);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText(String.format("в логе %s будет запись <%s>\n", pathToLog, entry));
    }

    @Override
    public void describeMismatchSafely(SSHRule rule, Description mismatchDescription) {
        try {
            mismatchDescription.appendText(String.format("в логе %s:%n%s",
                    pathToLog, executeCommAndResturnResultAsString(rule.conn(), String.format(
                    "less %s | grep '%s'", pathToLog, entry), logger)));
        } catch (Exception e) {
            throw new RuntimeException("не удалось открыть лог для поиска записи ", e);
        }
    }
}
