package ru.yandex.autotests.innerpochta.wmi.core.matchers.ssh;

import ch.ethz.ssh2.Connection;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import static org.hamcrest.CoreMatchers.equalTo;
import static ru.yandex.autotests.innerpochta.util.ssh.SSHCommands.executeCommAndResturnResultAsString;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 27.02.14
 * Time: 14:45
 * Матчер нужен для грепа ЛЮБЫХ логов за последние несколько минут.
 */
public class IsThereLogEntryWithTime extends TypeSafeMatcher<Connection> {

    protected final Logger logger = LogManager.getLogger(this.getClass());

    private String entry;
    private String pathToLog;
    private Matcher<Integer> matcher;
    private String currentDate;
    private Integer lastSeveralMinute;
    private SimpleDateFormat logFormat;

    public IsThereLogEntryWithTime(String pathToLog, String entry, int lastSeveralMinute, Matcher<Integer> matcher, SimpleDateFormat logFormat) {
        this.pathToLog = pathToLog;
        this.entry = entry;
        this.matcher = matcher;
        this.lastSeveralMinute = lastSeveralMinute;
        this.logFormat = logFormat;
    }

    /**
     * Грепаем текущую дату с точностью до n минут
     * <p/>
     * с помощью команды <date +%d/%m/%Y:%H:%M>
     *
     * @return возвращаем одной строчкой дату по которой будем грепать
     */
    public String grepDate(Connection connection, Integer lastSeveralMinute, SimpleDateFormat logFormat) throws IOException, ParseException {
        currentDate = StringUtils.chomp(executeCommAndResturnResultAsString(connection,
                "date +%d/%m/%Y:%H:%M", logger));
        //парсим в дату:
        SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy:HH:mm");
        Date date;
        date = formatDate.parse(currentDate);
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date);
        date = cal1.getTime();
        String result = logFormat.format(date);

        for (int i = 0; i < lastSeveralMinute; i++) {
            date = formatDate.parse(currentDate);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            //отматываем время назад
            cal.add(Calendar.MINUTE, -1);
            date = cal.getTime();
            formatDate.setCalendar(cal);
            currentDate = formatDate.format(date);

            result += "\\|" + logFormat.format(date);
        }
        return result;
    }


    public String grepFromLog(Connection connection, String entry, SimpleDateFormat logFormat) {
        logger.warn(String.format("Ищем в логе %s строчку: <%s> ", pathToLog, entry));
        try {
            currentDate = grepDate(connection, lastSeveralMinute, logFormat);
            return executeCommAndResturnResultAsString(connection, String.format(
                    "less %s | grep '%s' | grep -c '%s'", pathToLog, currentDate, entry), logger);
        } catch (Exception e) {
            throw new RuntimeException("не удалось открыть лог для поиска записи ", e);
        }
    }

    @Factory
    public static IsThereLogEntryWithTime hasEntryAtLastMinutes(String pathToLog, String entry, Integer minute,
                                                                Matcher<Integer> matcher, SimpleDateFormat format) {
        return new IsThereLogEntryWithTime(pathToLog, entry, minute, matcher, format);
    }

    @Factory
    public static IsThereLogEntryWithTime hasOneEntryAtLastMinutes(String pathToLog, String entry, Integer minute,
                                                                   SimpleDateFormat format) {
        return new IsThereLogEntryWithTime(pathToLog, entry, minute, equalTo(1), format);
    }

    @Override
    protected boolean matchesSafely(Connection connection) {
        Integer result = Integer.parseInt(
                StringUtils.chomp(grepFromLog(connection, entry, logFormat)));
        return matcher.matches(result);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText(String.format("в логе %s за последние несколько минут(%s) будет запись <%s>\n",
                pathToLog, lastSeveralMinute, entry));
    }

    @Override
    public void describeMismatchSafely(Connection connection, Description mismatchDescription) {
        try {
            currentDate = grepDate(connection, lastSeveralMinute, logFormat);
            mismatchDescription.appendText(String.format("в логе %s:%n%s",
                    pathToLog, executeCommAndResturnResultAsString(connection, String.format(
                    "less %s | grep '%s' | grep '%s'", pathToLog, currentDate, entry), logger)));
        } catch (Exception e) {
            throw new RuntimeException("не удалось открыть лог для поиска записи ", e);
        }
    }
}