package ru.yandex.autotests.innerpochta.wmi.core.matchers.ssh;

import ch.ethz.ssh2.Connection;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.qatools.allure.annotations.Step;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import static com.google.common.base.Splitter.on;
import static org.apache.commons.lang3.StringUtils.trimToEmpty;
import static ru.yandex.autotests.innerpochta.util.ssh.SSHCommands.executeCommAndResturnResultAsString;

/**
 * User: lanwen
 * Date: 28.04.14
 * Time: 21:51
 */
public class SSHCoresMatcher extends TypeSafeMatcher<Connection> {

    private Logger logger = LogManager.getLogger(this.getClass());
    private List<String> cores = new ArrayList<>();

    @Override
    @Step("[SSH]: Ищем корки")
    protected boolean matchesSafely(Connection connection) {
        String cmd = "ls -l /var/cores | awk '{ print $6\" \"$7\" \"$8\" \"$9 }' | sort";

        try {
            String result = cmd(connection, cmd);
            cores.addAll(on("\n").omitEmptyStrings().trimResults().splitToList(result));
        } catch (IOException e) {
            throw new RuntimeException("Can't fetch info about cores on " + connection.getHostname(), e);
        }
        return cores.isEmpty();
    }
    @Override
    public void describeTo(Description description) {
        description.appendText("Папка </var/cores> должна быть пуста");
    }

    @Override
    protected void describeMismatchSafely(Connection item, Description mismatchDescription) {
        mismatchDescription.appendText("найдены: \n").appendValueList("\t", "\n\t", "", cores);
    }

    @Factory
    public static SSHCoresMatcher hasNoCoreDumps() {
        return new SSHCoresMatcher();
    }


    @Step("[SSH]: {1}")
    private String cmd(Connection connection, String cmd) throws IOException {
        logger.info("CMD: " + cmd);
        return trimToEmpty(executeCommAndResturnResultAsString(connection, cmd, logger));
    }


}
